/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.protocol.data;

import com.velocitypowered.api.network.ProtocolVersion;
import java.util.Map;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.material.Item;
import net.elytrium.limbofilter.protocol.data.EntityMetadata;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;

public class ItemFrame {
    public static int getID(ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) <= 0) {
            return 71;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_14_4) <= 0) {
            return 35;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_15_2) <= 0) {
            return 36;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16_4) <= 0) {
            return 38;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_18_2) <= 0) {
            return 42;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_1) <= 0) {
            return 45;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_3) <= 0) {
            return 46;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) <= 0) {
            return 56;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_3) <= 0) {
            return 57;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21) <= 0) {
            return 60;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_2) <= 0) {
            return 71;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_5) <= 0) {
            return 70;
        }
        return 71;
    }

    public static byte getMetadataIndex(ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_7_6) <= 0) {
            return 2;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) <= 0) {
            return 8;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_9_4) <= 0) {
            return 5;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) <= 0) {
            return 6;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16_4) <= 0) {
            return 7;
        }
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_5) <= 0) {
            return 8;
        }
        return 9;
    }

    public static EntityMetadata createMapMetadata(LimboFactory limboFactory, ProtocolVersion protocolVersion, int mapId) {
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_12_2) <= 0) {
            return new EntityMetadata(Map.of(ItemFrame.getMetadataIndex(protocolVersion), new EntityMetadata.SlotEntry(limboFactory.getItem(Item.FILLED_MAP), 1, mapId, null, null)));
        }
        return new EntityMetadata(Map.of(ItemFrame.getMetadataIndex(protocolVersion), new EntityMetadata.SlotEntry(limboFactory.getItem(Item.FILLED_MAP), 1, 0, ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("map", (BinaryTag)IntBinaryTag.intBinaryTag((int)mapId))).build(), limboFactory.createItemComponentMap().add(ProtocolVersion.MINECRAFT_1_20_5, "minecraft:map_id", (Object)mapId))));
    }

    public static EntityMetadata createRotationMetadata(ProtocolVersion protocolVersion, int rotation) {
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) <= 0) {
            return new EntityMetadata(Map.of((byte)(ItemFrame.getMetadataIndex(protocolVersion) + 1), new EntityMetadata.ByteEntry(rotation % 4)));
        }
        return new EntityMetadata(Map.of((byte)(ItemFrame.getMetadataIndex(protocolVersion) + 1), new EntityMetadata.VarIntEntry(rotation)));
    }
}

