/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.protocol.packets;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Function;

public class SpawnEntity
implements MinecraftPacket {
    private final int id;
    private final UUID uuid;
    private final Function<ProtocolVersion, Integer> type;
    private final double positionX;
    private final double positionY;
    private final double positionZ;
    private final float pitch;
    private final float yaw;
    private final float headYaw;
    private final int data;
    private final float velocityX;
    private final float velocityY;
    private final float velocityZ;

    public SpawnEntity(int id, UUID uuid, Function<ProtocolVersion, Integer> type, double positionX, double positionY, double positionZ, float pitch, float yaw, float headYaw, int data, float velocityX, float velocityY, float velocityZ) {
        this.id = id;
        this.uuid = uuid;
        this.type = type;
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionZ = positionZ;
        this.pitch = pitch;
        this.yaw = yaw;
        this.headYaw = headYaw;
        this.data = data;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
    }

    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.id);
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) > 0) {
            ProtocolUtils.writeUuid((ByteBuf)buf, (UUID)this.uuid);
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) > 0) {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.type.apply(protocolVersion));
            } else {
                buf.writeByte(this.type.apply(protocolVersion).intValue());
            }
            buf.writeDouble(this.positionX);
            buf.writeDouble(this.positionY);
            buf.writeDouble(this.positionZ);
        } else {
            buf.writeByte(this.type.apply(protocolVersion).intValue());
            buf.writeInt((int)(this.positionX * 32.0));
            buf.writeInt((int)(this.positionY * 32.0));
            buf.writeInt((int)(this.positionZ * 32.0));
        }
        buf.writeByte((int)(this.pitch * 0.7111111f));
        buf.writeByte((int)(this.yaw * 0.7111111f));
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_18_2) > 0) {
            buf.writeByte((int)(this.headYaw * 0.7111111f));
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.data);
        } else {
            buf.writeInt(this.data);
        }
        buf.writeShort((int)(this.velocityX * 8000.0f));
        buf.writeShort((int)(this.velocityY * 8000.0f));
        buf.writeShort((int)(this.velocityZ * 8000.0f));
    }

    public boolean handle(MinecraftSessionHandler handler) {
        return true;
    }
}

