/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import net.elytrium.pcap.PcapException;
import net.elytrium.pcap.PcapNative;
import net.elytrium.pcap.data.PcapDevice;
import net.elytrium.pcap.data.PcapError;
import net.elytrium.pcap.data.PcapPacketHeader;
import net.elytrium.pcap.data.TstampPrecision;
import net.elytrium.pcap.data.TstampType;
import net.elytrium.pcap.handle.BpfProgram;
import net.elytrium.pcap.handle.PcapHandle;
import net.elytrium.pcap.layer.data.LinkType;

public class Pcap {
    private static final boolean IS_JAVA_CRITICAL = PcapNative.isJavaCritical();

    public static boolean isJavaCritical() {
        return IS_JAVA_CRITICAL;
    }

    public static void init() throws PcapException {
        String error = PcapNative.init();
        if (error != null) {
            throw new PcapException(error);
        }
    }

    public static int[] lookupnet(String device) throws PcapException {
        int[] data = new int[2];
        if (PcapNative.lookupnet(device, data) < 0) {
            throw new PcapException(PcapNative.getErrorBuffer());
        }
        return data;
    }

    public static PcapHandle create(String source) throws PcapException {
        long address = PcapNative.create(source);
        if (address == 0L) {
            throw new PcapException(PcapNative.getErrorBuffer());
        }
        return new PcapHandle(address);
    }

    public static List<PcapDevice> findAllDevs() throws PcapException {
        long address = PcapNative.findAllDevs();
        if (address == 0L) {
            throw new PcapException(PcapNative.getErrorBuffer());
        }
        List<PcapDevice> devices = PcapDevice.read(address);
        PcapNative.freeAllDevs(address);
        return devices;
    }

    public static PcapHandle openLive(String device, int snaplen, int promisc, int timeout) throws PcapException {
        long address = PcapNative.openLive(device, snaplen, promisc, timeout);
        if (address == 0L) {
            throw new PcapException(PcapNative.getErrorBuffer());
        }
        return new PcapHandle(address);
    }

    public static PcapHandle openOffline(String fname) throws PcapException {
        long address = PcapNative.openOffline(fname);
        if (address == 0L) {
            throw new PcapException(PcapNative.getErrorBuffer());
        }
        return new PcapHandle(address);
    }

    public static PcapHandle openOffline(String fname, TstampPrecision precision) throws PcapException {
        long address = PcapNative.openOfflineWithTstampPrecision(fname, precision.ordinal());
        if (address == 0L) {
            throw new PcapException(PcapNative.getErrorBuffer());
        }
        return new PcapHandle(address);
    }

    public static PcapHandle openDead(LinkType linktype, int snaplen) throws PcapException {
        long address = PcapNative.openDead(linktype.getValue(), snaplen);
        if (address == 0L) {
            throw new PcapException();
        }
        return new PcapHandle(address);
    }

    public static PcapHandle openDead(LinkType linktype, int snaplen, TstampPrecision precision) throws PcapException {
        long address = PcapNative.openDeadWithTstampPrecision(linktype.getValue(), snaplen, precision.ordinal());
        if (address == 0L) {
            throw new PcapException();
        }
        return new PcapHandle(address);
    }

    public static String getTstampTypeName(TstampType type) {
        return PcapNative.tstampTypeValToName(type.ordinal());
    }

    public static String getTstampTypeDescription(TstampType type) {
        return PcapNative.tstampTypeValToDescription(type.ordinal());
    }

    public static TstampType getTstampType(String name) throws PcapException {
        int value = PcapNative.tstampTypeNameToVal(name);
        if (value < 0) {
            PcapError.throwIfNotSuccess(value);
            return null;
        }
        return TstampType.values()[value];
    }

    public static String statusToString(PcapError status) {
        return PcapNative.statusToString(status.getValue());
    }

    public static String stringError(int errno) {
        return PcapNative.stringError(errno);
    }

    public static String stringError() {
        return PcapNative.stringErrorErrno();
    }

    public static boolean offlineFilter(BpfProgram program, PcapPacketHeader header, ByteBuffer buffer) {
        Objects.requireNonNull(buffer, "buffer");
        return PcapNative.offlineFilter(program.getAddress(), header.getAddress(), buffer) > 0;
    }

    public static LinkType getDatalink(String name) {
        return LinkType.getByValue(PcapNative.datalinkNameToVal(name));
    }

    public static String getDatalinkName(LinkType linkType) {
        return PcapNative.datalinkValToName(linkType.getValue());
    }

    public static String getDatalinkDescription(LinkType linkType) {
        return PcapNative.datalinkValToDescription(linkType.getValue());
    }

    public static String getDatalinkDescriptionOrDlt(LinkType linkType) {
        return PcapNative.datalinkValToDescriptionOrDlt(linkType.getValue());
    }

    public static String libVersion() {
        return PcapNative.libVersion();
    }
}

