/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.data;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.elytrium.pcap.memory.MemoryReader;

public class PcapAddress {
    private final InetSocketAddress address;
    private final InetSocketAddress netmask;
    private final InetSocketAddress broadcast;
    private final InetSocketAddress destination;

    public PcapAddress(InetSocketAddress address, InetSocketAddress netmask, InetSocketAddress broadcast, InetSocketAddress destination) {
        this.address = address;
        this.netmask = netmask;
        this.broadcast = broadcast;
        this.destination = destination;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getNetmask() {
        return this.netmask;
    }

    public InetSocketAddress getBroadcast() {
        return this.broadcast;
    }

    public InetSocketAddress getDestination() {
        return this.destination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PcapAddress that = (PcapAddress)o;
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.netmask, that.netmask)) {
            return false;
        }
        if (!Objects.equals(this.broadcast, that.broadcast)) {
            return false;
        }
        return Objects.equals(this.destination, that.destination);
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.netmask != null ? this.netmask.hashCode() : 0);
        result = 31 * result + (this.broadcast != null ? this.broadcast.hashCode() : 0);
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PcapAddress{address=" + this.address + ", netmask=" + this.netmask + ", broadcast=" + this.broadcast + ", destination=" + this.destination + '}';
    }

    public static List<PcapAddress> read(long address) {
        ArrayList<PcapAddress> addresses = new ArrayList<PcapAddress>();
        long next = address;
        while (next != 0L) {
            MemoryReader reader = new MemoryReader(next);
            next = reader.readAddress();
            addresses.add(new PcapAddress(reader.readSockaddr(), reader.readSockaddr(), reader.readSockaddr(), reader.readSockaddr()));
        }
        return addresses;
    }
}

