/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.elytrium.pcap.data.ConnectionStatus;
import net.elytrium.pcap.data.PcapAddress;
import net.elytrium.pcap.memory.MemoryReader;

public class PcapDevice {
    private final String name;
    private final String description;
    private final List<PcapAddress> addresses;
    private final int flags;

    public PcapDevice(String name, String description, List<PcapAddress> addresses, int flags) {
        this.name = name;
        this.description = description;
        this.addresses = addresses;
        this.flags = flags;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PcapAddress> getAddresses() {
        return this.addresses;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isLoopback() {
        return (this.flags & 1) != 0;
    }

    public boolean isUp() {
        return (this.flags & 2) != 0;
    }

    public boolean isRunning() {
        return (this.flags & 4) != 0;
    }

    public boolean isWireless() {
        return (this.flags & 8) != 0;
    }

    public ConnectionStatus getConnectionStatus() {
        return ConnectionStatus.fromFlags(this.flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PcapDevice that = (PcapDevice)o;
        if (this.flags != that.flags) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        return Objects.equals(this.addresses, that.addresses);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.addresses != null ? this.addresses.hashCode() : 0);
        result = 31 * result + this.flags;
        return result;
    }

    public String toString() {
        return "PcapDevice{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", addresses=" + this.addresses + ", flags=" + this.flags + '}';
    }

    public static List<PcapDevice> read(long address) {
        ArrayList<PcapDevice> devices = new ArrayList<PcapDevice>();
        long next = address;
        while (next != 0L) {
            MemoryReader reader = new MemoryReader(next);
            next = reader.readAddress();
            String name = reader.readString();
            String description = reader.readString();
            List<PcapAddress> addresses = PcapAddress.read(reader.readAddress());
            int flags = reader.readInt();
            devices.add(new PcapDevice(name, description, addresses, flags));
        }
        return devices;
    }
}

