/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.data;

import net.elytrium.pcap.PcapException;

public enum PcapError {
    SUCCESS,
    ERROR_GENERIC,
    ERROR_BREAK,
    ERROR_NOT_ACTIVATED,
    ERROR_ACTIVATED,
    ERROR_NO_SUCH_DEVICE,
    ERROR_RFMON_NOTSUP,
    ERROR_NOT_RFMON,
    ERROR_PERM_DENIED,
    ERROR_IFACE_NOT_UP,
    ERROR_CANTSET_TSTAMP_TYPE,
    ERROR_PROMISC_PERM_DENIED,
    ERROR_TSTAMP_PRECISION_NOTSUP,
    WARNING_GENERIC,
    WARNING_PROMISC_NOTSUP,
    WARNING_TSTAMP_TYPE_NOTSUP;


    public int getValue() {
        if (this == SUCCESS) {
            return 0;
        }
        if (this.isError()) {
            return -this.ordinal();
        }
        return this.ordinal() - 12;
    }

    public boolean isWarning() {
        return this.ordinal() > 12;
    }

    public boolean isError() {
        return this != SUCCESS && !this.isWarning();
    }

    public boolean isGeneric() {
        return this == ERROR_GENERIC || this == WARNING_GENERIC;
    }

    public static PcapError fromCode(int code) {
        if (code == 0) {
            return SUCCESS;
        }
        if (code < 0) {
            return PcapError.values()[-code];
        }
        return PcapError.values()[12 + code];
    }

    public static PcapError throwIfNotSuccess(PcapError error) throws PcapException {
        if (error != SUCCESS) {
            throw new PcapException(error);
        }
        return error;
    }

    public static PcapError throwIfNotSuccess(int code) throws PcapException {
        return PcapError.throwIfNotSuccess(PcapError.fromCode(code));
    }

    public static PcapError throwIfError(PcapError error) throws PcapException {
        if (error != null && error.isError()) {
            throw new PcapException(error);
        }
        return error;
    }

    public static PcapError throwIfError(int code) throws PcapException {
        return PcapError.throwIfError(PcapError.fromCode(code));
    }
}

