/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.handle;

import net.elytrium.pcap.PcapNative;
import net.elytrium.pcap.memory.MemoryUtil;
import sun.misc.Unsafe;

public class BpfProgram {
    private static final int SIZE = 4 + Unsafe.ADDRESS_SIZE;
    private final long address;

    public BpfProgram(long address) {
        this.address = address;
    }

    public BpfProgram() {
        Unsafe unsafe = MemoryUtil.getUnsafe();
        this.address = unsafe.allocateMemory(SIZE);
        unsafe.setMemory(this.address, SIZE, (byte)0);
    }

    public long getAddress() {
        return this.address;
    }

    public void freeCode() {
        PcapNative.freeCode(this.address);
    }

    public void freeMemory() {
        MemoryUtil.getUnsafe().freeMemory(this.address);
    }

    public void free() {
        this.freeCode();
        this.freeMemory();
    }
}

