/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.layer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.elytrium.pcap.layer.IPv6Header;
import net.elytrium.pcap.layer.data.IpProtocol;
import net.elytrium.pcap.layer.exception.LayerDecodeException;
import net.elytrium.pcap.layer.exception.LayerEncodeException;

public class IPv6Routing
extends IPv6Header {
    private int headerExtLength;
    private int routingType;
    private int segmentsLeft;
    private byte[] data;

    @Override
    public void decode(ByteBuffer buffer) throws LayerDecodeException {
        if (buffer.remaining() < 8) {
            throw new LayerDecodeException("Routing extension header is too small.");
        }
        this.nextHeader = IpProtocol.values()[Byte.toUnsignedInt(buffer.get())];
        this.headerExtLength = Byte.toUnsignedInt(buffer.get());
        this.routingType = Byte.toUnsignedInt(buffer.get());
        this.segmentsLeft = Byte.toUnsignedInt(buffer.get());
        this.data = new byte[this.headerExtLength * 8];
        buffer.get(this.data);
    }

    @Override
    public void encode(ByteBuffer buffer) throws LayerEncodeException {
        int size = this.getSize();
        if (buffer.remaining() < size) {
            throw new LayerEncodeException("ByteBuffer is too small.");
        }
        int position = buffer.position() + size;
        buffer.put((byte)this.nextHeader.ordinal());
        buffer.put((byte)this.headerExtLength);
        buffer.put((byte)this.routingType);
        buffer.put((byte)this.segmentsLeft);
        buffer.put(new byte[position - buffer.position()]);
    }

    @Override
    public int getSize() {
        return 4 + this.data.length + 7 & 0xFFFFFFF8;
    }

    public int getHeaderExtLength() {
        return this.headerExtLength;
    }

    public void setHeaderExtLength(int headerExtLength) {
        this.headerExtLength = headerExtLength;
    }

    public int getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(int routingType) {
        this.routingType = routingType;
    }

    public int getSegmentsLeft() {
        return this.segmentsLeft;
    }

    public void setSegmentsLeft(int segmentsLeft) {
        this.segmentsLeft = segmentsLeft;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "IPv6Routing{headerExtLength=" + this.headerExtLength + ", routingType=" + this.routingType + ", segmentsLeft=" + this.segmentsLeft + ", data=" + Arrays.toString(this.data) + ", nextHeader=" + (Object)((Object)this.nextHeader) + '}';
    }
}

