/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.layer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import net.elytrium.pcap.layer.EthernetProtocolHeader;
import net.elytrium.pcap.layer.Layer;
import net.elytrium.pcap.layer.data.EthernetProtocol;
import net.elytrium.pcap.layer.exception.LayerDecodeException;
import net.elytrium.pcap.layer.exception.LayerEncodeException;

public class LinuxSLL
implements EthernetProtocolHeader {
    private static final int SIZE = 16;
    private PacketType packetType;
    private int addressType;
    private int addressLength;
    private byte[] address;
    private EthernetProtocol protocol;

    @Override
    public void decode(ByteBuffer buffer) throws LayerDecodeException {
        if (buffer.remaining() < 16) {
            throw new LayerDecodeException("Linux SLL packet is too small.");
        }
        this.packetType = PacketType.values()[buffer.getShort()];
        this.addressType = buffer.getShort();
        this.addressLength = buffer.getShort();
        this.address = new byte[8];
        buffer.get(this.address);
        int protocol = Short.toUnsignedInt(buffer.getShort());
        this.protocol = EthernetProtocol.getByValue(protocol);
    }

    @Override
    public void encode(ByteBuffer buffer) throws LayerEncodeException {
        if (buffer.remaining() < 16) {
            throw new LayerEncodeException("ByteBuffer is too small.");
        }
        buffer.putShort((short)this.packetType.ordinal());
        buffer.putShort((short)this.addressType);
        buffer.putShort((short)this.addressLength);
        buffer.put(this.address, 0, 8);
        buffer.putShort((short)this.protocol.getValue());
    }

    @Override
    public int getSize() {
        return 16;
    }

    @Override
    public Supplier<Layer> nextLayer() {
        return this.protocol != null ? this.protocol.getLayer() : null;
    }

    public PacketType getPacketType() {
        return this.packetType;
    }

    public void setPacketType(PacketType packetType) {
        this.packetType = packetType;
    }

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int addressType) {
        this.addressType = addressType;
    }

    public int getAddressLength() {
        return this.addressLength;
    }

    public void setAddressLength(int addressLength) {
        this.addressLength = addressLength;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    @Override
    public EthernetProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(EthernetProtocol protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return "LinuxSLL{packetType=" + (Object)((Object)this.packetType) + ", addressType=" + this.addressType + ", addressLength=" + this.addressLength + ", address=" + Arrays.toString(this.address) + ", protocol=" + (Object)((Object)this.protocol) + '}';
    }

    public static enum PacketType {
        HOST,
        BROADCAST,
        MULTICAST,
        OTHER_HOST,
        OUTGOING,
        LOOPBACK,
        FASTROUTE;

    }
}

