/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.layer;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.elytrium.pcap.layer.Layer;
import net.elytrium.pcap.layer.exception.LayerDecodeException;
import net.elytrium.pcap.layer.exception.LayerEncodeException;

public class UDP
implements Layer {
    private static final int SIZE = 8;
    private int srcPort;
    private int dstPort;
    private int length;
    private short checksum;

    @Override
    public void decode(ByteBuffer buffer) throws LayerDecodeException {
        if (buffer.remaining() < 8) {
            throw new LayerDecodeException("UDP header is too small.");
        }
        this.srcPort = Short.toUnsignedInt(buffer.getShort());
        this.dstPort = Short.toUnsignedInt(buffer.getShort());
        this.length = Short.toUnsignedInt(buffer.getShort());
        this.checksum = buffer.getShort();
    }

    @Override
    public void encode(ByteBuffer buffer) throws LayerEncodeException {
        if (buffer.remaining() < 8) {
            throw new LayerEncodeException("ByteBuffer is too small.");
        }
        buffer.putShort((short)this.srcPort);
        buffer.putShort((short)this.dstPort);
        buffer.putShort((short)this.length);
        buffer.putShort(this.checksum);
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public Supplier<Layer> nextLayer() {
        return null;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public void setDstPort(int dstPort) {
        this.dstPort = dstPort;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public void setChecksum(short checksum) {
        this.checksum = checksum;
    }

    public String toString() {
        return "UDP{srcPort=" + this.srcPort + ", dstPort=" + this.dstPort + ", length=" + this.length + ", checksum=" + this.checksum + '}';
    }
}

