/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.layer.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.elytrium.pcap.layer.IPv4;
import net.elytrium.pcap.layer.IPv6;
import net.elytrium.pcap.layer.Layer;

public enum EthernetProtocol {
    LOOP(96),
    NORTEL_DISC(418),
    PUP(512),
    PUPAT(513),
    CISCO_DISC(8192),
    TSN(8944),
    ERSPAN2(8939),
    IP(2048, IPv4::new),
    X25(2053),
    ARP(2054),
    BPQ(2303),
    IEEEPUP(2560),
    IEEEPUPAT(2561),
    BATMAN(17157),
    DEC(24576),
    DNA_DL(24577),
    DNA_RC(24578),
    DNA_RT(24579),
    LAT(24580),
    DIAG(24581),
    CUST(24582),
    SCA(24583),
    TEB(25944),
    RARP(32821),
    ATALK(32923),
    AARP(33011),
    VLAN8021Q(33024),
    ERSPAN(35006),
    IPX(33079),
    IPV6(34525, IPv6::new),
    PAUSE(34824),
    SLOW(34825),
    PPP(34827),
    WCCP(34878),
    MPLS_UC(34887),
    MPLS_MC(34888),
    ATMMPOA(34892),
    PPP_DISC(34915),
    PPP_SES(34916),
    LINK_CTL(34924),
    ATMFATE(34948),
    PAE(34958),
    PROFINET(34962),
    REALTEK(34969),
    AOE(34978),
    ETHERCAT(34980),
    VLAN8021AD(34984),
    LE802_EX1(34997),
    PREAUTH(35015),
    TIPC(35018),
    LLDP(35020),
    MRP(35043),
    MACSEC(35045),
    BST8021AH(35047),
    MVRP(35061),
    IEEE1588(35063),
    NCSI(35064),
    PRP(35067),
    CFM(35074),
    FCOE(35078),
    IBOE(35093),
    TDLS(35085),
    FIP(35092),
    IEEE80221(35095),
    HSR(35119),
    NSH(35151),
    LOOPBACK(36864),
    QINQ1(37120),
    QINQ2(37376),
    QINQ3(37632),
    EDSA(56026),
    DSA_8021Q(56027),
    IFE(60734),
    AF_IUCV(64507);

    private static final Map<Integer, EthernetProtocol> REGISTRY;
    private final int value;
    private final Supplier<Layer> layer;

    private EthernetProtocol(int value, Supplier<Layer> linkType) {
        this.value = value;
        this.layer = linkType;
    }

    private EthernetProtocol(int value) {
        this.value = value;
        this.layer = null;
    }

    public int getValue() {
        return this.value;
    }

    public Supplier<Layer> getLayer() {
        return this.layer;
    }

    public static EthernetProtocol getByValue(int value) {
        return REGISTRY.get(value);
    }

    static {
        REGISTRY = new HashMap<Integer, EthernetProtocol>();
        for (EthernetProtocol protocol : EthernetProtocol.values()) {
            REGISTRY.put(protocol.getValue(), protocol);
        }
    }
}

