/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.layer.data;

import java.util.HashMap;
import java.util.Map;

public enum TCPOptionType {
    EOOL(0, false),
    NOOP(1, false),
    MSS(2),
    WS(3),
    SACKP(4),
    SACK(5),
    TS(8),
    TFO(34);

    private static final Map<Integer, TCPOptionType> REGISTRY;
    private final int value;
    private final boolean hasData;

    private TCPOptionType(int value, boolean hasData) {
        this.value = value;
        this.hasData = hasData;
    }

    private TCPOptionType(int value) {
        this.value = value;
        this.hasData = true;
    }

    public int getValue() {
        return this.value;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public static TCPOptionType getByValue(int value) {
        return REGISTRY.get(value);
    }

    static {
        REGISTRY = new HashMap<Integer, TCPOptionType>();
        for (TCPOptionType option : TCPOptionType.values()) {
            REGISTRY.put(option.getValue(), option);
        }
    }
}

