/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.memory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import net.elytrium.pcap.memory.MemoryUtil;
import sun.misc.Unsafe;

public class MemoryReader {
    private long address;

    public MemoryReader(long address) {
        this.address = address;
    }

    public void skipBytes(int n) {
        this.address += (long)n;
    }

    public byte readByte() {
        try {
            byte by = MemoryUtil.getUnsafe().getByte(this.address);
            return by;
        }
        finally {
            ++this.address;
        }
    }

    public short readShort() {
        try {
            short s = MemoryUtil.getUnsafe().getShort(this.address);
            return s;
        }
        finally {
            this.address += 2L;
        }
    }

    public int readInt() {
        try {
            int n = MemoryUtil.getUnsafe().getInt(this.address);
            return n;
        }
        finally {
            this.address += 4L;
        }
    }

    public long readLong() {
        try {
            long l = MemoryUtil.getUnsafe().getLong(this.address);
            return l;
        }
        finally {
            this.address += 8L;
        }
    }

    public long readAddress() {
        try {
            long l = MemoryUtil.getUnsafe().getAddress(this.address);
            return l;
        }
        finally {
            this.address += (long)Unsafe.ADDRESS_SIZE;
        }
    }

    public byte[] readBytes(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readByte();
        }
        return array;
    }

    public byte[] readBytes(int length) {
        return this.readBytes(new byte[length]);
    }

    public InetSocketAddress readSockaddr() {
        byte[] addr;
        short port;
        long address = this.readAddress();
        if (address == 0L) {
            return null;
        }
        MemoryReader reader = new MemoryReader(address);
        short family = reader.readShort();
        if (family == 2) {
            port = reader.readShort();
            addr = reader.readBytes(4);
        } else if (family == 10) {
            port = reader.readShort();
            reader.skipBytes(4);
            addr = reader.readBytes(16);
        } else {
            return null;
        }
        try {
            return new InetSocketAddress(InetAddress.getByAddress(addr), (int)port);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public String readString() {
        String string;
        long address = this.readAddress();
        if (address == 0L) {
            return null;
        }
        MemoryReader reader = new MemoryReader(address);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            byte b;
            while ((b = reader.readByte()) != 0) {
                outputStream.write(b);
            }
            string = outputStream.toString("UTF-8");
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        outputStream.close();
        return string;
    }

    public long getAddress() {
        return this.address;
    }

    public void setAddress(long address) {
        this.address = address;
    }
}

